#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

struct Point {
    long long x, y;
    
    bool operator<(const Point& p) const {
        return x < p.x || (x == p.x && y < p.y);
    }

    long long cross(const Point& p1, const Point& p2) const {
        return (p1.x - x) * (p2.y - y) - (p1.y - y) * (p2.x - x);
    }
};

long long polygon_area(const vector<Point>& p) {
    long long area = 0;
    int n = p.size();
    for (int i = 0; i < n; ++i) {
        int j = (i + 1) % n;
        area += p[i].x * p[j].y;
        area -= p[j].x * p[i].y;
    }
    return abs(area);
}

vector<Point> convex_hull(vector<Point>& points) {
    sort(points.begin(), points.end());
    vector<Point> hull;
    for (const auto& p : points) {
        while (hull.size() >= 2 && hull[hull.size() - 2].cross(hull[hull.size() - 1], p) <= 0) {
            hull.pop_back();
        }
        hull.push_back(p);
    }

    int t = hull.size() + 1;
    for (int i = points.size() - 1; i >= 0; --i) {
        while (hull.size() >= t && hull[hull.size() - 2].cross(hull[hull.size() - 1], points[i]) <= 0) {
            hull.pop_back();
        }
        hull.push_back(points[i]);
    }

    hull.pop_back();
    return hull;
}

int main() {
    int N;
    cin >> N;
    vector<Point> points(N);
    for (int i = 0; i < N; ++i) {
        cin >> points[i].x >> points[i].y;
    }

    vector<Point> hull = convex_hull(points);
    
    
    vector<Point> hull_part = vector<Point>(hull.begin(), hull.begin() + min((int)hull.size(), N-1));
    
    long long area = polygon_area(hull_part);
    cout << area << endl;

    return 0;
}